s = 1;
a = 20;
b = .05;
c = 2*pi;

f = @(x) s*(a - a*exp(-b * sqrt(.5*(x(1)^2 + x(2)^2))) + exp(1) - exp(.5*(cos(c*x(1)) + cos(c*x(2)))));
Df = @(x) s * [a*b*x(1)/sqrt(2*(x(1)^2 + x(2)^2))*exp(-b * sqrt(.5*(x(1)^2 + x(2)^2))) + c/2*sin(c*x(1))*exp(.5*(cos(c*x(1)) + cos(c*x(2)))), ...
               a*b*x(2)/sqrt(2*(x(1)^2 + x(2)^2))*exp(-b * sqrt(.5*(x(1)^2 + x(2)^2))) + c/2*sin(c*x(2))*exp(.5*(cos(c*x(1)) + cos(c*x(2))))];

x0s = [-3.5; 2.5] + rand(2, 20) -.5;

tol = 1e-6;
maxIter = 20;
sigma = .3;
evolutions = 10;

xms = evolutionaryBFGS(f, Df, x0s, tol, maxIter, sigma, evolutions);

x1m = min(xms(1, :)) -.2; x1M = max(xms(1, :)) +.2;
x2m = min(xms(2, :)) -.2; x2M = max(xms(2, :)) +.2;
res = 2^10;

%% matlab plot
[x1, x2] = ndgrid(linspace(x1m, x1M, res), linspace(x2m, x2M, res));
z = zeros(size(x1));
for kk=1:numel(x1)
    z(kk) = f([x1(kk); x2(kk)]);
end

evols = 0:evolutions;
fxms = zeros(size(evols));
for kk=0:evolutions
    fxms(kk+1) = f(xms(:, kk+1));
end

figure();

subplot(1,2,1);
contour(x1, x2, nthroot(z, 2), 25);
hold on
plot(xms(1, :), xms(2, :), 'k-+');
hold off
axis equal
title("Pfad des kleinsten Funktionswert gefunden bis Generation")

subplot(1,2,2);
plot(evols, fxms, 'k-*');
title("Wert des kleinsten Funktionswert gefunden bis Generation")