package gol;

import javax.swing.*;
import java.awt.*;

import static java.lang.Thread.sleep;

/** 
 * Grafische Visualisierung vom Game Of Life mittels AWT.
 */
public class GOLWindow extends JFrame {

  GameOfLife gol;

  /**
   * Kreiert eine Visualisierung mit dem das übergebene Game Of Life
   * angezeigt und simuliert werden kann.
   */
  public GOLWindow(GameOfLife gol) {
    this.gol = gol;
    this.add(new GOLDrawingArea(gol));
    this.pack();
    setVisible(true);
  }


  /**
   * Diese Methode führt numSteps update steps für das
   * übergebene GameOfLife-objekt aus und visualisiert jeden Zwischenschritt.
   * Nutzen Sie die Methode java.lang.Thread.sleep um jeweils 1 Sekunde zwischen
   * zwei Schritten zu warten.
   */
  public void run(int numSteps) throws Exception {
    // Ihre Implementation
  }

  public static void main(String[] args) throws Exception {
    GameOfLife gol = GameOfLife.createRandom(100, 0.3);
    GOLWindow golF = new GOLWindow(gol);
    golF.run(1000);
  }

}

/**
 * Dieses Panel repräsentiert die Zeichenfläche, mit der mittels den AWT Befehlen
 * gezeichnet werden kann.
 */
class GOLDrawingArea extends JPanel {

  GameOfLife gol;

  /**
   * Kreiert eine Visualisierung mit dem das übergebene Game Of Life
   * angezeigt und simuliert werden kann.
   */
  GOLDrawingArea(GameOfLife gol) {
    this.gol = gol;
    setSize(600, 600);
  }


  /**
   * Zeichnet den aktuellen Zustand vom Game of Life. 
   * Zum Zeichnen wird das übergebene Grafik objekt g genutzt.
   */
  public void paint(Graphics g) {
    
    // Ihre Implementation
  }

  // Gibt die gewünschte Grösse des Fensters zurück.
  public Dimension getPreferredSize() {
    return new Dimension(600, 600);
  }
}


/**
 * Dieses Panel repräsentiert die Zeichenfläche, mit der mittels den AWT Befehlen
 * gezeichnet werden kann. Im Gegensatz zur Klasse GOLDrawingArea 
 * wird hier double buffering verwendet
 */
class GOLDrawingAreaDoubleBuffering extends JPanel {


  GameOfLife gol;

 /**
   * Kreiert eine Visualisierung mit dem das übergebene Game Of Life
   * angezeigt und simuliert werden kann.
   */
  GOLDrawingAreaDoubleBuffering(GameOfLife gol) {
    this.gol = gol;
    setSize(600, 600);
  }


   /**
   * Zeichnet den aktuellen Zustand vom Game of Life. 
   * Zum Zeichnen wird das übergebene Grafik objekt g genutzt.
   */
  public void paint(Graphics g) {
    // Ihre Implementation
  }

  // Gibt die gewünschte Grösse des Fensters zurück.
  public Dimension getPreferredSize() {
    return new Dimension(600, 600);
  }
}
