package streams;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class LambdasAndStreams {

  /**
   * Hilfsklasse um Postleitzahl und Ort
   * zusammenzufassen
   */
  static class PLZOrt {
    public int plz;
    public String ort;

    PLZOrt(int plz, String ort) {
      this.plz = plz;
      this.ort = ort;
    }

    @Override
    public String toString() {
      return ort+"["+plz+"]";
    }
  }

  /**
   * Die Daten
   */
  public static PLZOrt[] getData() {
    PLZOrt[] plzAndOrt = {
        new PLZOrt(5000,"Aarau"),
        new PLZOrt(4000,"Basel"),
        new PLZOrt(3000,"Bern"),
        new PLZOrt(7000,"Chur"),
        new PLZOrt(1000,"Lausanne"),
        new PLZOrt(6000,"Luzern"),
        new PLZOrt(2000,"Neuchatel"),
        new PLZOrt(9000,"St.Gallen"),
        new PLZOrt(8000,"Zürich") };

    return plzAndOrt;
  }

  /**
   * Erzeugt eine Funktion (Consumer), 
   * welche einen gegebenen String auf die 
   * Konsole ausgibt. 
   */
  static Consumer<String> printIt() {

    // Ihre Implementation
    return null;

  }

  /**
   * Erzeugt einen Comparator, welcher die 
   * Postleitzahlen numerisch vergleicht.
   */
  static Comparator<PLZOrt> getComparator() {

      // Ihre Implementation
      return null;
  }

  /**
   * Erzeugt einen Filter, welche für eine gegebenes 
   * Objekt vom Typ PLZOrt true zurückgibt, falls die 
   * Postleitzahl kleiner als der Threshold ist.
   */
  static Predicate<PLZOrt> filterSmaller(int threshold) {
  
      // Ihre Implementation
      return null;

  }

  /**
   * Erzeugt eine Funktion, welche für ein Objekt vom 
   * Typ PLZOrt jeweils den Ort extrahiert.
   */
  static Function<PLZOrt, String> extractOrt() {
   
      // Ihre Implementation
      return null;

  }


  public static void main(String[] args) {

    int threshold = 5000;

    List<PLZOrt> list = Arrays.asList(getData());

    Stream<PLZOrt> stream = list.stream();

    stream
        .filter( filterSmaller(threshold) )
        .sorted( getComparator() )
        .map( extractOrt() )
        .forEach( printIt());
  }

}
