package streams;

import org.junit.Test;

import static org.junit.Assert.*;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

import edu.illinois.cs.cs125.gradlegrader.annotations.Graded;
import edu.illinois.cs.cs125.gradlegrader.annotations.Tag;


public class LambdasAndStreamsTests {

   
    @Test(timeout = 1000)  
    @Graded(points = 1)
    @Tag(name = "difficulty", value = "simple")
    @Tag(name = "function", value = "testPrintIt")
    public void testPrintIt() {

      ByteArrayOutputStream outContent = new ByteArrayOutputStream();
      PrintStream originalOut = System.out;      
      System.setOut(new PrintStream(outContent));       
    
      
      Consumer<String> consumer = LambdasAndStreams.printIt();
      consumer.accept("abc");

      String output = outContent.toString();
      assertEquals("abc", output.trim());
      System.setOut(originalOut);
    }

    @Test(timeout = 1000)  
    @Graded(points = 1)
    @Tag(name = "difficulty", value = "simple")
    @Tag(name = "function", value = "testComparator")
    public void testComparator() {

      Comparator<LambdasAndStreams.PLZOrt> comparator = LambdasAndStreams.getComparator();
      LambdasAndStreams.PLZOrt plzOrt1 = new LambdasAndStreams.PLZOrt(8000, "TestOrt1");
      LambdasAndStreams.PLZOrt plzOrt2 = new LambdasAndStreams.PLZOrt(3000, "TestOrt2");
      assertTrue(LambdasAndStreams.getComparator().compare(plzOrt1, plzOrt2) > 0);
      assertTrue( LambdasAndStreams.getComparator().compare(plzOrt2, plzOrt1) < 0);
      assertEquals(0, LambdasAndStreams.getComparator().compare(plzOrt1, plzOrt1));
    }


    @Test(timeout = 1000)  
    @Graded(points = 1)
    @Tag(name = "difficulty", value = "simple")
    @Tag(name = "function", value = "testFilter")
    public void testFilter() {
      Predicate<LambdasAndStreams.PLZOrt> pred = LambdasAndStreams.filterSmaller(5000);
      LambdasAndStreams.PLZOrt plzOrt1 = new LambdasAndStreams.PLZOrt(8000, "TestOrt1");
      LambdasAndStreams.PLZOrt plzOrt2 = new LambdasAndStreams.PLZOrt(3000, "TestOrt2");

      assertFalse(pred.test(plzOrt1));
      assertTrue(pred.test(plzOrt2));
    }

    @Test(timeout = 1000)  
    @Graded(points = 1)
    @Tag(name = "difficulty", value = "simple")
    @Tag(name = "function", value = "testMap")
    public void testMap() {
      Function<LambdasAndStreams.PLZOrt, String> extractor = LambdasAndStreams.extractOrt();

      LambdasAndStreams.PLZOrt plzOrt = new LambdasAndStreams.PLZOrt(8000, "TestOrt1");
      assertEquals("TestOrt1", extractor.apply(plzOrt));

    }


    
}

