
import edu.illinois.cs.cs125.gradlegrader.annotations.Graded;
import edu.illinois.cs.cs125.gradlegrader.annotations.Tag;
import org.junit.Test;
import java.io.PrintStream;
import java.io.ByteArrayOutputStream;
import static org.junit.Assert.assertEquals;

public class CrosssumTest {


    @Test(timeout = 1000)
    @Graded(points = 1)
    @Tag(name = "difficulty", value = "simple")
    @Tag(name = "function", value = "CrosssumCorrectPositive")
    public void testCrosssumCorrectPositive() {
        assertEquals(8, runCrossSumAndCaptureOutput(17));
        assertEquals(1, runCrossSumAndCaptureOutput(1));
        assertEquals(4, runCrossSumAndCaptureOutput(1111));
    }


    @Test(timeout = 1000)
    @Graded(points = 1)
    @Tag(name = "difficulty", value = "simple")
    @Tag(name = "function", value = "CrosssumCorrectNegative")
    public void testCrosssumCorrectNegativeAndZero() {
        assertEquals(-26, runCrossSumAndCaptureOutput(-998));
        assertEquals(-7, runCrossSumAndCaptureOutput(-16));
        assertEquals(0, runCrossSumAndCaptureOutput(0));
    }



    private int runCrossSumAndCaptureOutput(
        int number
    ) {
        
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        PrintStream originalOut = System.out;
        
        System.setOut(new PrintStream(outContent));       
        
        String[] args = { Integer.valueOf(number).toString() };
        
        CrossSum.main(args);
        String output = outContent.toString();        
        System.setOut(originalOut);
        return Integer.parseInt(output.trim());
        
    }           
}
