
import edu.illinois.cs.cs125.gradlegrader.annotations.Graded;
import edu.illinois.cs.cs125.gradlegrader.annotations.Tag;
import org.junit.Test;
import java.io.PrintStream;
import java.io.ByteArrayOutputStream;
import static org.junit.Assert.assertTrue;

public class CubicRootTest {


    @Test(timeout = 1000)
    @Graded(points = 3)
    @Tag(name = "difficulty", value = "simple")
    @Tag(name = "function", value = "cubicRootOkay")
    public void testCubicRootPositiveInstances() {

        assertTrue(Math.abs(1.0 - runCubicRootAndCaptureOutput(1.0)) < 1e-6);
        assertTrue(Math.abs(2.0 - runCubicRootAndCaptureOutput(8.0)) < 1e-6);
        assertTrue(Math.abs(3.0 - runCubicRootAndCaptureOutput(27)) < 1e-6);
    }


    @Test(timeout = 1000)
    @Graded(points = 1)
    @Tag(name = "difficulty", value = "simple")
    @Tag(name = "function", value = "cubicRootOkay")
    public void testCubicRootZero() {
        assertTrue(Math.abs(0.0 - runCubicRootAndCaptureOutput(0.0)) < 1e-6);
    }



    private double runCubicRootAndCaptureOutput(
        double number
    ) {
        
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        PrintStream originalOut = System.out;
        
        System.setOut(new PrintStream(outContent));       
        
        String[] args = { Double.valueOf(number).toString() };
        
        CubicRoot.main(args);
        String output = outContent.toString();        
        System.setOut(originalOut);
        return Double.parseDouble(output.trim());
        
    }           
}
