
import edu.illinois.cs.cs125.gradlegrader.annotations.Graded;
import edu.illinois.cs.cs125.gradlegrader.annotations.Tag;
import org.junit.Test;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import static org.junit.Assert.*;

public class TurtlePatternsTest {


    @Test(timeout = 10000)
    @Graded(points = 1)
    @Tag(name = "difficulty", value = "simple")
    @Tag(name = "function", value = "TurtlePatterns")
    public void testCallProduceTwoDiffernetOutputImage() {
        try {

            File outputImageFile1 = File.createTempFile("pattern1", ".png");
            String[] args1 = {"1", outputImageFile1.getAbsolutePath()};            
            TurtlePatterns.main(args1);

            File outputImageFile2 = File.createTempFile("pattern2", ".png");
            String[] args2 = {"2", outputImageFile2.getAbsolutePath()};            
            TurtlePatterns.main(args2);

            BufferedImage image1 = ImageIO.read(outputImageFile1);
            BufferedImage image2 = ImageIO.read(outputImageFile2);
            assertEquals(image1.getWidth(), image2.getWidth());
            assertEquals(image1.getHeight(), image2.getHeight());

            // the two images should not be the same
            boolean imageEquals = true;
            for (int i = 0; i < image1.getWidth(); i++) {
                for (int j = 0; j < image1.getHeight(); j++) {
                    imageEquals = imageEquals && (image1.getRGB(i, j) == image2.getRGB(i, j));
                }
            }
            assert(imageEquals == false);
            
        } catch (IOException e) {
            fail("IOException occured " +e.getMessage());
            e.printStackTrace();
            fail();
        }

    }
}
