
import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import ch.unibas.informatik.jturtle.Turtle;
import java.io.IOException;

public class TurtlePixelGraphics  {

  static final int PIXEL_WIDTH = 2;
  static final int NUMBER_OF_PIXELS_PER_LINE = 50;
  static final int NUMBER_OF_LINES = 50;
  

  /**
   * Zeichnet einen Pixel an der aktuellen TurtlePosition. 
   * Das Argument filled bestimmt ob der Pixel mit der aktuellen 
   * Zeichenfarbe ausgefüllt werden soll. 
   */
  static void drawPixel(Turtle turtle, boolean filled) {

    turtle.penDown();
    turtle.forward(PIXEL_WIDTH);
    turtle.turnRight(90);
    turtle.forward(PIXEL_WIDTH);
    turtle.turnRight(90);
    turtle.forward(PIXEL_WIDTH);
    turtle.turnRight(90);
    turtle.forward(PIXEL_WIDTH);
    turtle.turnRight(90);
    turtle.penUp();

    if (filled) {
      turtle.forward(PIXEL_WIDTH / 2);
      turtle.turnRight(90);
      turtle.forward(PIXEL_WIDTH / 2);
      turtle.fill();
      turtle.backward(PIXEL_WIDTH / 2);
      turtle.turnLeft(90);
      turtle.backward(PIXEL_WIDTH / 2);
    }
    turtle.forward(PIXEL_WIDTH);
    turtle.penDown();

  }

  /**
   * Bringt das Turtle auf den Anfang einer Zeile
   */
  static void newLine(Turtle turtle) {

    turtle.penUp();
    turtle.backward(NUMBER_OF_PIXELS_PER_LINE * 2);
    turtle.turnRight(90); turtle.forward(PIXEL_WIDTH);
    turtle.turnLeft(90);
    turtle.penDown();
  }

  /**
   * Zeichnet das übergebene (binäre) Bild. Dabei sollen die 
   * Methoden newLine und drawPixel genutzt werden. 
   */
  public static void drawImage(Turtle turtle, boolean[][] image) {

    // Ihre Implementation kommt hierhin
  
  }

  /**
   * Beschreibt die implizite Kreisgleichung x^2 + y^2 -radius^2 < 0. Gibt true 
   * zurück wenn x und y innerhalb des mit obiger Gleichung beschriebenen Kreises ist
   * und ansonsten false. 
   */
  public static boolean implicitCircle(double radius, double x, double y) {
    // Ihre Implementation kommt hierhin
    return true; // ersetzen Sie diese Zeile mit dem richtigen Rückgabewert
  }


  /**
   * Diese Methode soll ein (binäres) Bild erstellen, das einen Kreis mit Radius r im 
   * Zentrum des Bildes zeigt.
   * Dabei soll die oben definierte Methode implicitCircle benutzt werden. 
   */
  public static void drawCircleImage(Turtle turtle, int radius) {

    // Das Array, welches die Bildinformation beinhaltet
    boolean[][] twoDArray = new boolean[NUMBER_OF_LINES][NUMBER_OF_PIXELS_PER_LINE];

    //  Ihre Implementation kommt hierhin
    
  }



  /**
   * Die Main Methode nimmt als Argument den Radius des Kreises sowie einen 
   * Dateinamen (mit Endung .png)
   * In diese Datei wird dann das erzeugte Bild geschrieben.  
   */
  public static void main(String[] args) throws IOException {

    Turtle turtle = new Turtle();
    int radius = Integer.parseInt(args[0]);
    String outputFilename = args[1];
    

    drawCircleImage(turtle, radius);
   
    BufferedImage image = turtle.toImage();
    ImageIO.write(turtle.toImage(), "png", new File(outputFilename));
  }
}