
import edu.illinois.cs.cs125.gradlegrader.annotations.Graded;
import edu.illinois.cs.cs125.gradlegrader.annotations.Tag;
import org.junit.Test;
import java.io.PrintStream;
import java.util.Arrays;
import java.io.ByteArrayOutputStream;
import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.assertEquals;

public class BubbleSortTests {


    @Test(timeout = 1000)
    @Graded(points = 1)
    @Tag(name = "difficulty", value = "simple")
    @Tag(name = "function", value = "BubbleSortTest1")
    public void testSwap() {

        int[] a = {7, 1, 8, 9, 12, 7, 6};
        int[] aCopy = Arrays.copyOf(a,  a.length);

        // nothing should change
        BubbleSort.swap(3, 3, a);
        assertArrayEquals(aCopy, a);

        // elements should be swapped
        BubbleSort.swap(1, 4, a);
        assertEquals(aCopy[1], a[4]);
        assertEquals(aCopy[4], a[1]);

    }

    @Test(timeout = 1000)
    @Graded(points = 1)
    @Tag(name = "difficulty", value = "simple")
    @Tag(name = "function", value = "BubbleSortTest2")
    public void sortsDifferentlySortedSequences() {

        int[] a1 = {7, 1, 8, 9, 12, 7, 6};
        int[] a1Sorted = {1, 6, 7, 7, 8, 9, 12};
        int[] a2 = {1, 2, 3, 4, 5, 6, 7};
        int[] a2Sorted = {1, 2, 3, 4, 5, 6, 7};
        int[] a3 = {7, 6, 5, 4, 3, 2, 1, 0};
        int[] a3Sorted = {0, 1, 2, 3, 4, 5, 6, 7 };

        BubbleSort.sort(a1);
        assertArrayEquals(a1Sorted, a1);
        BubbleSort.sort(a2);
        assertArrayEquals(a2Sorted, a2);
        BubbleSort.sort(a3);
        assertArrayEquals(a3Sorted, a3);


    }

    
    @Test(timeout = 1000)
    @Graded(points = 1)
    @Tag(name = "difficulty", value = "simple")
    @Tag(name = "function", value = "BubbleSortTest2")
    public void sortEdgeCases() {

        int[] emptySequence = {};
        int[] emptySequenceSorted = {};
    
        int[] oneElementSequence = {1};
        int[] oneElementSequenceSorted = {1};
        
        BubbleSort.sort(emptySequence);
        assertArrayEquals(emptySequenceSorted, emptySequence);

        BubbleSort.sort(oneElementSequence);
        assertArrayEquals(oneElementSequenceSorted, oneElementSequence);
    }


}
