
import edu.illinois.cs.cs125.gradlegrader.annotations.Graded;
import edu.illinois.cs.cs125.gradlegrader.annotations.Tag;
import org.junit.Test;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.fail;

public class MatrixTests {


    @Test(timeout = 1000)
    @Graded(points = 1)
    @Tag(name = "difficulty", value = "simple")
    @Tag(name = "function", value = "transposeTests")
    public void transposeTestsRegularCases() {
        double[][] m = {{1, 2}, {3, 4}, {5, 6}};
        double[][] mt = {{1, 3, 5}, {2, 4, 6}};

        assertMatrixEquals(mt, Matrix.transpose(m));
    }

    @Test(timeout = 1000)
    @Graded(points = 1)
    @Tag(name = "difficulty", value = "simple")
    @Tag(name = "function", value = "transposeTestMatrixPreserved")
    public void testMatrixIsPreserved() {
        double[][] m = {{1, 2}, {3, 4}, {5, 6}};
        double[][] mCopy = {{1, 2}, {3, 4}, {5, 6}};
        
        Matrix.transpose(m);
        assertMatrixEquals(m, mCopy);
    }

    private void assertMatrixEquals(double[][] m1, double[][] m2) {
        if (m1.length != m2.length) {
            fail("matrix dimensions not the same: " + m1.length + " != " + m2.length);
        }
        if (m1.length == 0) {
            return; // two empty matrices -> always equal
        }
        if (m1[0].length != m2[0].length) {
            fail("matrix dimensions not the same: " + m1[0].length + " != " + m2[0].length);
        }
        for (int i = 0; i < m1.length; ++i) {
            for (int j = 0 ; j < m1[i].length; ++j) {
                if (m1[i][j] != m2[i][j]) {
                    fail("element with index " + i + ", " + j + " not equal (" +m1[i][j] + " != " +m2[i][j] + ")");
                }
            } 
            
        }
    }

}
