
import edu.illinois.cs.cs125.gradlegrader.annotations.Graded;
import edu.illinois.cs.cs125.gradlegrader.annotations.Tag;
import org.junit.Test;
import ch.unibas.informatik.jturtle.Turtle;
import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import static org.junit.Assert.*;

public class TurtlePixelGraphicsTests {

    @Test(timeout = 10000)
    @Graded(points = 1)
    @Tag(name = "difficulty", value = "simple")
    @Tag(name = "function", value = "TurtlePixelGraphicsTestsCircleEquation")
    public void testCircleEquation() {
        assertEquals(true, TurtlePixelGraphics.implicitCircle(1, 0, 0));
        assertEquals(true, TurtlePixelGraphics.implicitCircle(3, 1, 1));
        assertEquals(false, TurtlePixelGraphics.implicitCircle(1, 1, 1));
    }

    @Test(timeout = 10000)
    @Graded(points = 2)
    @Tag(name = "difficulty", value = "simple")
    @Tag(name = "function", value = "TurtlePixelGraphicsTestsDrawImage")
    public void testDrawImage() {

        try {

            File groundTruthImageFile = new File("src/test/resources/squareImage.png");
            BufferedImage groundTruthImage = ImageIO.read(groundTruthImageFile);

            boolean[][] img = new boolean[TurtlePixelGraphics.NUMBER_OF_LINES][TurtlePixelGraphics.NUMBER_OF_PIXELS_PER_LINE];
            for (int i = 0; i < img.length; i++) {
                for (int j = 0; j < img[i].length; j++) {
                    if (i >= img.length / 4 && j >= img.length / 4 && i <= (int) (img.length * 3 / 4.0)
                            && j <= (int) (img.length * 3 / 4.0)) {
                        img[i][j] = true;
                    } else {
                        img[i][j] = false;
                    }
                }
            }

            Turtle turtle = new Turtle();
            TurtlePixelGraphics.drawImage(turtle, img);
            BufferedImage drawnImage = turtle.toImage();
            
            assertImageEquals(groundTruthImage, drawnImage);

        } catch (Exception e) {
            System.out.println(e.getMessage());
        }

    }

    @Test(timeout = 10000)
    @Graded(points = 2)
    @Tag(name = "difficulty", value = "simple")
    @Tag(name = "function", value = "TurtlePixelGraphicsTestsCircleImage")
    public void testCircleImage() {

        try {

            File groundTruthImageFile = new File("src/test/resources/circleImage.png");
            BufferedImage groundTruthImage = ImageIO.read(groundTruthImageFile);

            Turtle turtle = new Turtle();

            TurtlePixelGraphics.drawCircleImage(turtle, 20);
            BufferedImage drawnImage = turtle.toImage();

            assertImageEquals(groundTruthImage, drawnImage);

        } catch (Exception e) {
            System.out.println(e.getMessage());
        }

    }

    void assertImageEquals(BufferedImage groundTruthImage, BufferedImage drawnImage) {

        assertEquals("heigth matches", groundTruthImage.getHeight(), drawnImage.getHeight());
        assertEquals("width matches", groundTruthImage.getWidth(), drawnImage.getWidth());

        for (int i = 0; i < groundTruthImage.getWidth(); i++) {
            for (int j = 0; j < groundTruthImage.getHeight(); j++) {
                assertEquals("Pixel (" + i + ", " + j + ") matches", groundTruthImage.getRGB(i, j),
                        drawnImage.getRGB(i, j));
            }
        }
    }

}
