package sortedlist;

/**
 * Abstrakte Klasse die einen Knoten in einer verketteten Liste
 * repräsentiert. Die Knoten können verglichen und entsprechend
 * sortiert werden. 
 */
abstract class ListNode {
  ListNode next;

  /**
   * gibt true zurück, falls der Wert im aktuellen Objekt kleiner
   * als der Wert im übergebenen Knoten x ist.
   */
  public abstract boolean isLessThan(ListNode x);

  /**
   * Gibt true zurück, falls der in diesem Objekt gespeicherte Wert 
   * gleich dem Wert ist, der im Knoten x gespeichert ist.
   */
  public abstract boolean isEqualTo(ListNode x);

  /**
   * Gibt den Wert dieses Knotens als String zurück.
   */
  public abstract String toString();
}