# This file serves as a template which has a few functions already implemented to decrease the work-load.
# Feel free to edit the file however you want. The code in this file is not set in stone.

import random

# the symbols that appear in the game
symbols = ['O', 'X', '-', '*']
emptySymbol = '.'
# the dimensions of the game grid
w, h = 4, 6


# the method containing the main loop
def startGame():
    # initialize game: creating a two dimensional array of size [w][h], filled with random symbols
    grid = [[symbols[random.randint(0, len(symbols) - 1)] for y in range(h)] for x in range(w)]
    score = 0
    firstRound = True

    # the game master loop
    while True:

        # are there blocks to eliminate?
        scorePlus = eliminateMatches(grid)
        while scorePlus > 0:  # blocks were eliminated
            score += scorePlus
            dropDown(grid)  # let the hovering blocks fall down
            fillUp(grid)  # fill the empty spaces with new blocks
            scorePlus = eliminateMatches(grid)  # maybe a new match appeared?

        # we do not want to give the player free points at the start of the game
        if firstRound:
            score = 0
            firstRound = False

        # drawing the game
        draw(grid, score)

        # the player can give input
        (pos1, pos2) = getInput()

        # swapping the two specified blocks
        swap(pos1, pos2, grid)


# drawing the game
def draw(grid, score):
    # TODO : show game grid and score in the terminal
    None


# we ask the player which tiles he/she wants to swap
def getInput():
    # TODO : get input from player about which two tiles we have to swap and validate the input

    # replace this line with your own implementation
    theInput = input("This is how you can get keyboard input from the terminal: ")

    # in python we can return tuples of tuples, which is quite handy
    return ((0, 0), (1, 0))


# has the player entered a position that we can work with?
def isValidInput(positionString):
    # TODO : determine whether the given input is valid
    return True


# changing the symbols of the two blocks in the grid
def swap(pos1, pos2, grid):
    # TODO : swap the two given positions in the grid
    None


# checking for matches of length 3 or higher
# return the score that is won by the elimination
#
#    +---+---+---+
#    | X | X | X |    <- this is an example of a match!
#    +---+---+---+
#
# a match is defined as at least three blocks in a straight line
# a match may give a score of its length minus 2 (eg. 3-match gives 1 point, 4-match gives 2 points etc...)
def eliminateMatches(grid):
    # TODO : eliminate horizontal and vertical matches
    return 0


# checks whether point x,y is inside the grid
def isInsideGrid(x, y):
    return 0 <= x < w and 0 <= y < h


# letting the blocks fall down
#
#    +---+      +---+
#    | X |      | . |
#    +---+  ->  +---+
#    | . |      | X |
#    +---+      +---+
def dropDown(grid):
    dropped = True  # just to get into the while loop
    # we continue for as long as there are blocks falling down
    while dropped:
        dropped = False  # nothing dropped yet

        for x in range(w):
            # it is important to come at this from below, otherwise blocks could fall onto other blocks
            # that still hover in mid-air
            for y in range(h - 1, 0, -1):
                # we can drop the block above on the current empty slot
                if grid[x][y] == emptySymbol and grid[x][y - 1] != emptySymbol:
                    grid[x][y] = grid[x][y - 1]
                    grid[x][y - 1] = emptySymbol
                    dropped = True


# filling the grid with new content
# any slot which has the value 'emptySymbol' is replaced by a new random symbol
def fillUp(grid):
    for x in range(w):
        for y in range(h):
            if grid[x][y] == emptySymbol:
                grid[x][y] = symbols[random.randint(0, len(symbols) - 1)]


# with this, running the file from console will automatically execute the game
if __name__ == '__main__':
    startGame()
