/*
 * Decompiled with CFR 0.152.
 */
import shadow.org.junit.runner.Description;
import shadow.org.junit.runner.Result;
import shadow.org.junit.runner.notification.Failure;
import shadow.org.junit.runner.notification.RunListener;

public class ConsolePrinter
extends RunListener {
    String status = null;

    @Override
    public void testFinished(Description description) throws Exception {
        System.out.println(description.getMethodName() + " " + this.status);
    }

    @Override
    public void testFailure(Failure failure) throws Exception {
        this.status = "(failed)";
    }

    @Override
    public void testIgnored(Description description) throws Exception {
        this.status = "(ignored)";
    }

    @Override
    public void testStarted(Description description) {
        this.status = "(passed)";
    }

    @Override
    public void testRunFinished(Result result) {
        System.out.println();
        if (result.getFailureCount() == 0) {
            System.out.println("All " + result.getRunCount() + " tests ended successfully");
        } else if (result.getFailureCount() == 1) {
            System.out.println(result.getFailureCount() + " test failed");
        } else {
            System.out.println(result.getFailureCount() + " tests failed");
        }
    }
}

