/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.informatik.cs101;

import ch.unibas.informatik.cs101.ImageWindowMouseListener;
import ch.unibas.informatik.cs101.KeyListener;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;

public class ImageWindow
extends Component {
    private BufferedImage _image;
    private Graphics2D _imageGraphics;
    private JFrame _jFrame;
    private ImageWindowMouseListener _imageWindowMouseListener;
    private KeyListener _keyListener;

    public ImageWindow(int width, int height) {
        this._image = new BufferedImage(width, height, 2);
        this._imageGraphics = (Graphics2D)this._image.getGraphics();
        this._imageWindowMouseListener = new ImageWindowMouseListener();
        this._keyListener = new KeyListener();
        this.clearImage();
    }

    public void resizeImage(int newWidth, int newHeight) {
        BufferedImage newImage = new BufferedImage(newWidth, newHeight, 2);
        newImage.getGraphics().setColor(new Color(255, 255, 255, 255));
        ((Graphics2D)newImage.getGraphics()).fill(new Rectangle2D.Float(0.0f, 0.0f, newWidth, newHeight));
        newImage.getGraphics().drawImage(this._image, 0, 0, null);
        this._image = newImage;
        this._imageGraphics = (Graphics2D)this._image.getGraphics();
        this._jFrame.pack();
    }

    public void clearImage() {
        this.fillImage(255, 255, 255);
    }

    public void fillImage(int red, int green, int blue) {
        Color color = new Color(red, green, blue, 255);
        this._imageGraphics.setColor(color);
        this._imageGraphics.fill(new Rectangle2D.Float(0.0f, 0.0f, this._image.getWidth(), this._image.getHeight()));
    }

    public void loadImage(String filePath) {
        File imageFile = new File(filePath);
        if (!imageFile.exists()) {
            System.err.println("File not found: " + filePath);
        }
        try {
            BufferedImage img = ImageIO.read(imageFile);
            this._imageGraphics.drawImage((Image)img, 0, 0, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setPixel(int x, int y, int red, int green, int blue) {
        try {
            this._image.setRGB(x, y, new Color(red, green, blue).getRGB());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public Color getPixel(int x, int y) {
        try {
            return new Color(this._image.getRGB(x, y));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return new Color(255, 255, 255, 255);
        }
    }

    public int getPixelRed(int x, int y) {
        return this.getPixel(x, y).getRed();
    }

    public int getPixelBlue(int x, int y) {
        return this.getPixel(x, y).getBlue();
    }

    public int getPixelGreen(int x, int y) {
        return this.getPixel(x, y).getGreen();
    }

    public void openWindow(String windowName, int x, int y) {
        if (this._jFrame != null) {
            this._jFrame.dispose();
        }
        this._jFrame = new JFrame(windowName);
        this._jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ImageWindow.this._jFrame != null) {
                    ImageWindow.this._jFrame.dispose();
                    ImageWindow.this._jFrame = null;
                }
            }
        });
        this.addMouseListener(this._imageWindowMouseListener);
        this._jFrame.setLocation(x, y);
        this._jFrame.addKeyListener(this._keyListener);
        this._jFrame.add(this);
        this._jFrame.pack();
        this._jFrame.setVisible(true);
    }

    public void openWindow() {
        this.openWindow("ImageWindow", 0, 0);
    }

    public void closeWindow() {
        if (this._jFrame == null) {
            return;
        }
        this._jFrame.dispose();
        this._jFrame = null;
    }

    public boolean isWindowOpen() {
        return this._jFrame != null;
    }

    public void redraw() {
        if (this._jFrame != null) {
            this._jFrame.repaint();
        }
    }

    public int getMouseXPos() {
        return this.getMousePos().x;
    }

    public int getMouseYPos() {
        return this.getMousePos().y;
    }

    public Point getMousePos() {
        try {
            Point mousePoint = MouseInfo.getPointerInfo().getLocation();
            Point componentPoint = this.getLocationOnScreen();
            Point p = new Point(mousePoint.x - componentPoint.x, mousePoint.y - componentPoint.y);
            return p;
        }
        catch (IllegalComponentStateException e) {
            return new Point(-1, -1);
        }
    }

    public void setMousePos(int x, int y) {
        Point imageLocation = this.getLocationOnScreen();
        try {
            Robot robot = new Robot();
            robot.mouseMove(imageLocation.x + x, imageLocation.y + y);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    public boolean mousePressed() {
        return this._imageWindowMouseListener.mousePressed();
    }

    public boolean isKeyDown(int keyCode) {
        return this._keyListener.isKeyDown(keyCode);
    }

    public void pause(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public int getImageWidth() {
        return this._image.getWidth();
    }

    public int getImageHeight() {
        return this._image.getHeight();
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(this._image, 0, 0, null);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this._image.getWidth(), this._image.getHeight());
    }
}

