/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import shadow.org.junit.After;
import shadow.org.junit.Before;
import shadow.org.junit.Test;

public class Bin2DecTest {
    private ByteArrayOutputStream outContent;
    private ByteArrayOutputStream errContent;
    private PrintStream originalOut;
    private PrintStream originalErr;

    @Before
    public void setUpStreams() {
        this.originalOut = System.out;
        this.originalErr = System.err;
        this.outContent = new ByteArrayOutputStream();
        this.errContent = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.outContent));
        System.setErr(new PrintStream(this.errContent));
    }

    @After
    public void cleanUpStreams() {
        System.setOut(this.originalOut);
        System.setErr(this.originalErr);
    }

    public String getOut() {
        return this.outContent.toString();
    }

    public String getErr() {
        return this.errContent.toString();
    }

    private String[] generate(int ... digits) {
        String[] rt = new String[digits.length];
        for (int c = 0; c < digits.length; ++c) {
            rt[c] = Integer.toString(digits[c]);
        }
        return rt;
    }

    @Test
    public void aufgabe1_Bin2Dec_MainMethodTest() {
        Bin2Dec.main((String[])this.generate(1));
    }

    @Test
    public void aufgabe1_Bin2Dec_ShortBinTest1() {
        Bin2Dec.main((String[])this.generate(1, 0));
        this.getOut().trim().equals("3");
    }

    @Test
    public void aufgabe1_Bin2Dec_ShortBinTest2() {
        Bin2Dec.main((String[])this.generate(1, 0, 0, 1));
        this.getOut().trim().equals("9");
    }

    @Test
    public void aufgabe1_Bin2Dec_LeadingZeroTest() {
        Bin2Dec.main((String[])this.generate(0, 1, 0, 1, 0));
        this.getOut().trim().equals("10");
    }

    @Test
    public void aufgabe1_Bin2Dec_LongBinTest() {
        Bin2Dec.main((String[])this.generate(1, 0, 0, 0, 1, 0, 0, 1));
        this.getOut().trim().equals("137");
    }
}

