/*
 * Decompiled with CFR 0.152.
 */
import ch.unibas.informatik.cs101.ImageWindow;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import shadow.org.junit.AfterClass;
import shadow.org.junit.Assert;
import shadow.org.junit.BeforeClass;
import shadow.org.junit.Test;

public class ImageArraysTest {
    private static final int MARGIN = 5;
    private static final String[] PICTURES = new String[]{"rotaten90.jpg", "rotatep90.jpg", "miroircc1.jpg", "miroircc2.jpg"};

    @BeforeClass
    public static void setUp() throws IOException {
        ImageArraysTest c = new ImageArraysTest();
        for (String s : PICTURES) {
            InputStream is = ImageArraysTest.class.getClassLoader().getResourceAsStream(s);
            FileOutputStream os = new FileOutputStream(new File(".\\" + s));
            int read = 0;
            while ((read = is.read()) != -1) {
                os.write(read);
            }
            os.flush();
            os.close();
        }
    }

    @AfterClass
    public static void cleanUp() {
        for (String s : PICTURES) {
            File f = new File(s);
            if (!f.exists()) continue;
            f.delete();
        }
    }

    private boolean compare(ImageWindow w1, ImageWindow w2) {
        for (int x = 0; x < 500; ++x) {
            for (int y = 0; y < 500; ++y) {
                if (Math.abs(w1.getPixelRed(x, y) - w2.getPixelRed(x, y)) > 5) {
                    return false;
                }
                if (Math.abs(w1.getPixelGreen(x, y) - w2.getPixelGreen(x, y)) > 5) {
                    return false;
                }
                if (Math.abs(w1.getPixelBlue(x, y) - w2.getPixelBlue(x, y)) <= 5) continue;
                return false;
            }
        }
        return true;
    }

    private boolean compareRed(ImageWindow w1, ImageWindow w2) {
        for (int x = 0; x < 500; ++x) {
            for (int y = 0; y < 500; ++y) {
                if (Math.abs(w1.getPixelRed(x, y) - w2.getPixelRed(x, y)) <= 5) continue;
                return false;
            }
        }
        return true;
    }

    private boolean compareGreen(ImageWindow w1, ImageWindow w2) {
        for (int x = 0; x < 500; ++x) {
            for (int y = 0; y < 500; ++y) {
                if (Math.abs(w1.getPixelGreen(x, y) - w2.getPixelGreen(x, y)) <= 5) continue;
                return false;
            }
        }
        return true;
    }

    private boolean compareBlue(ImageWindow w1, ImageWindow w2) {
        for (int x = 0; x < 500; ++x) {
            for (int y = 0; y < 500; ++y) {
                if (Math.abs(w1.getPixelBlue(x, y) - w2.getPixelBlue(x, y)) <= 5) continue;
                return false;
            }
        }
        return true;
    }

    private static void extractImage(ImageWindow w) {
        BufferedImage b = new BufferedImage(500, 500, 1);
        for (int x = 0; x < 500; ++x) {
            for (int y = 0; y < 500; ++y) {
                Color c = new Color(w.getPixelRed(x, y), w.getPixelGreen(x, y), w.getPixelBlue(x, y));
                b.setRGB(x, y, c.getRGB());
            }
        }
        File out = new File("tmp.jpg");
        try {
            ImageIO.write((RenderedImage)b, "JPEG", out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void aufgabe2_ImageArrays_MainMethodTest() {
        ImageArrays.main((String[])new String[0]);
        ImageArrays.sourceWindow.closeWindow();
        ImageArrays.destinationWindow.closeWindow();
        ImageArrays.destinationWindow2.closeWindow();
    }

    @Test
    public void aufgabe2_ImageArrays_Rotate90Test() {
        ImageArrays.main((String[])new String[0]);
        ImageWindow testWp = new ImageWindow(500, 500);
        testWp.openWindow("testWp", 0, 0);
        testWp.loadImage("rotatep90.jpg");
        testWp.redraw();
        ImageWindow testWn = new ImageWindow(500, 500);
        testWn.openWindow("testWn", 0, 0);
        testWn.loadImage("rotaten90.jpg");
        testWn.redraw();
        ImageArraysTest.extractImage(ImageArrays.destinationWindow);
        ImageWindow origW = new ImageWindow(500, 500);
        origW.openWindow("origW", 0, 0);
        origW.loadImage("tmp.jpg");
        origW.redraw();
        Assert.assertTrue(this.compare(origW, testWp) || this.compare(origW, testWn));
        File f = new File("tmp.jpg");
        if (f.exists()) {
            f.delete();
        }
        origW.closeWindow();
        testWp.closeWindow();
        testWn.closeWindow();
        ImageArrays.sourceWindow.closeWindow();
        ImageArrays.destinationWindow.closeWindow();
        ImageArrays.destinationWindow2.closeWindow();
    }

    @Test
    public void aufgabe2_ImageArrays_MiroirRedTest() {
        ImageArrays.main((String[])new String[0]);
        ImageWindow testWp = new ImageWindow(500, 500);
        testWp.openWindow("testWp", 0, 0);
        testWp.loadImage("miroircc1.jpg");
        testWp.redraw();
        ImageWindow testWn = new ImageWindow(500, 500);
        testWn.openWindow("testWn", 0, 0);
        testWn.loadImage("miroircc2.jpg");
        testWn.redraw();
        ImageArraysTest.extractImage(ImageArrays.destinationWindow2);
        ImageWindow origW = new ImageWindow(500, 500);
        origW.openWindow("origW", 0, 0);
        origW.loadImage("tmp.jpg");
        origW.redraw();
        Assert.assertTrue(this.compareRed(origW, testWp) || this.compareRed(origW, testWn));
        File f = new File("tmp.jpg");
        if (f.exists()) {
            f.delete();
        }
        origW.closeWindow();
        testWp.closeWindow();
        testWn.closeWindow();
        ImageArrays.sourceWindow.closeWindow();
        ImageArrays.destinationWindow.closeWindow();
        ImageArrays.destinationWindow2.closeWindow();
    }

    @Test
    public void aufgabe2_ImageArrays_MiroirGreenTest() {
        ImageArrays.main((String[])new String[0]);
        ImageWindow testWp = new ImageWindow(500, 500);
        testWp.openWindow("testWp", 0, 0);
        testWp.loadImage("miroircc1.jpg");
        testWp.redraw();
        ImageWindow testWn = new ImageWindow(500, 500);
        testWn.openWindow("testWn", 0, 0);
        testWn.loadImage("miroircc2.jpg");
        testWn.redraw();
        ImageArraysTest.extractImage(ImageArrays.destinationWindow2);
        ImageWindow origW = new ImageWindow(500, 500);
        origW.openWindow("origW", 0, 0);
        origW.loadImage("tmp.jpg");
        origW.redraw();
        Assert.assertTrue(this.compareGreen(origW, testWp) || this.compareGreen(origW, testWn));
        File f = new File("tmp.jpg");
        if (f.exists()) {
            f.delete();
        }
        origW.closeWindow();
        testWp.closeWindow();
        testWn.closeWindow();
        ImageArrays.sourceWindow.closeWindow();
        ImageArrays.destinationWindow.closeWindow();
        ImageArrays.destinationWindow2.closeWindow();
    }

    @Test
    public void aufgabe2_ImageArrays_MiroirBlueTest() {
        ImageArrays.main((String[])new String[0]);
        ImageWindow testWp = new ImageWindow(500, 500);
        testWp.openWindow("testWp", 0, 0);
        testWp.loadImage("miroircc1.jpg");
        testWp.redraw();
        ImageWindow testWn = new ImageWindow(500, 500);
        testWn.openWindow("testWn", 0, 0);
        testWn.loadImage("miroircc2.jpg");
        testWn.redraw();
        ImageArraysTest.extractImage(ImageArrays.destinationWindow2);
        ImageWindow origW = new ImageWindow(500, 500);
        origW.openWindow("origW", 0, 0);
        origW.loadImage("tmp.jpg");
        origW.redraw();
        Assert.assertTrue(this.compareBlue(origW, testWp) || this.compareBlue(origW, testWn));
        File f = new File("tmp.jpg");
        if (f.exists()) {
            f.delete();
        }
        origW.closeWindow();
        testWp.closeWindow();
        testWn.closeWindow();
        ImageArrays.sourceWindow.closeWindow();
        ImageArrays.destinationWindow.closeWindow();
        ImageArrays.destinationWindow2.closeWindow();
    }
}

