/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import shadow.org.junit.After;
import shadow.org.junit.Assert;
import shadow.org.junit.Before;
import shadow.org.junit.Test;

public class BubbleSortTest {
    private ByteArrayOutputStream outContent;
    private ByteArrayOutputStream errContent;
    private PrintStream originalOut;
    private PrintStream originalErr;

    @Before
    public void setUpStreams() {
        this.originalOut = System.out;
        this.originalErr = System.err;
        this.outContent = new ByteArrayOutputStream();
        this.errContent = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.outContent));
        System.setErr(new PrintStream(this.errContent));
    }

    @After
    public void cleanUpStreams() {
        System.setOut(this.originalOut);
        System.setErr(this.originalErr);
    }

    public String getOut() {
        return this.outContent.toString();
    }

    public String getErr() {
        return this.errContent.toString();
    }

    @Test
    public void aufgabe3_BubbleSort_MainMethodTest() {
        String[] inp = new String[]{"Bla"};
        BubbleSort.main((String[])inp);
    }

    @Test
    public void aufgabe3_BubbleSort_SwapMethodTest() {
        char[] fr = new char[]{'3', '2', '1'};
        BubbleSort.swap((int)0, (int)2, (char[])fr);
        Assert.assertTrue(fr[0] == '1' && fr[1] == '2' && fr[2] == '3');
        BubbleSort.swap((int)0, (int)1, (char[])fr);
        Assert.assertTrue(fr[0] == '2' && fr[1] == '1' && fr[2] == '3');
    }

    @Test
    public void aufgabe3_BubbleSort_SortMethodTest() {
        char[] testar = new char[]{'e', 'z', 'g', 'd', 'n', 'z', 'a', 'q', 'z', 'v'};
        BubbleSort.sort((char[])testar);
        Assert.assertTrue(testar.length == 10);
        char co = testar[0];
        for (int c = 1; c < testar.length; ++c) {
            Assert.assertTrue(co <= testar[c]);
            co = testar[c];
        }
    }

    @Test
    public void aufgabe3_BubbleSort_DisplayArrayMethodTest() {
        char[] testar = new char[]{'a', 'b', 'c', 'd', 'e'};
        BubbleSort.displayArray((char[])testar);
        String r = this.getOut();
        Assert.assertTrue(r.indexOf(97) < r.indexOf(98) && r.indexOf(98) < r.indexOf(99) && r.indexOf(99) < r.indexOf(100) && r.indexOf(100) < r.indexOf(101) && r.indexOf(97) > -1);
        r = r.replaceFirst("a", "");
        r = r.replaceFirst("b", "");
        r = r.replaceFirst("c", "");
        r = r.replaceFirst("d", "");
        r = r.replaceFirst("e", "");
        Assert.assertTrue(!r.contains("a") && !r.contains("b") && !r.contains("c") && !r.contains("d") && !r.contains("e"));
    }
}

