/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import shadow.org.junit.After;
import shadow.org.junit.Assert;
import shadow.org.junit.Before;
import shadow.org.junit.Test;

public class Dec2HexTest {
    private ByteArrayOutputStream outContent;
    private ByteArrayOutputStream errContent;
    private PrintStream originalOut;
    private PrintStream originalErr;

    private String[] generate(int number) {
        String[] input = new String[]{Integer.toString(number)};
        return input;
    }

    @Before
    public void setUpStreams() {
        this.originalOut = System.out;
        this.originalErr = System.err;
        this.outContent = new ByteArrayOutputStream();
        this.errContent = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.outContent));
        System.setErr(new PrintStream(this.errContent));
    }

    @After
    public void cleanUpStreams() {
        System.setOut(this.originalOut);
        System.setErr(this.originalErr);
    }

    public String getOut() {
        return this.outContent.toString();
    }

    public String getErr() {
        return this.errContent.toString();
    }

    @Test
    public void aufgabe1_Dec2Hex_MainMethodTest() {
        Dec2Hex.main((String[])this.generate(0));
    }

    @Test
    public void aufgabe1_Dec2Hex_Parameter0Test() {
        Dec2Hex.main((String[])this.generate(0));
        Assert.assertTrue(this.getOut().contains("0x0") || this.getOut().contains("0x00"));
    }

    @Test
    public void aufgabe1_Dec2Hex_ShortNumberTest1() {
        Dec2Hex.main((String[])this.generate(439));
        Assert.assertTrue(this.getOut().toUpperCase().contains("0X1B7") || this.getOut().toUpperCase().contains("0X01B7"));
    }

    @Test
    public void aufgabe1_Dec2Hex_ShortNumberTest2() {
        Dec2Hex.main((String[])this.generate(382));
        Assert.assertTrue(this.getOut().toUpperCase().contains("0X17E") || this.getOut().toUpperCase().contains("0X017E"));
    }

    @Test
    public void aufgabe1_Dec2Hex_LongNumberTest() {
        Dec2Hex.main((String[])this.generate(347864546));
        Assert.assertTrue(this.getOut().toUpperCase().contains("0X14BBFDE2") || this.getOut().toUpperCase().contains("0X014BBFDE2"));
    }
}

