/**
 * HeapSort.
 * HeapSort kann auf der Konsole genau gleich verwendet werden wie
 * BubbleSort:
 * >java HeapSort 'zu sortierendes Array' 
 **/

public class HeapSort {

    /**
     * Sortiert das Eingabearray und aendert das Array in place.
     **/
    public static void sort(char[] characters) {
        int h_size = characters.length;
        assertHeapRules(characters, h_size);
        while(h_size>1) {
            swapFirst(characters, --h_size);
            siftDown(characters, h_size, 0);
        }
    }

    /**
     * Build heap.
     * When we start we have to ensure that we have a heap.
     **/
    public static void assertHeapRules(char[] characters, int h_size) {
        for (int idx=h_size/2; idx>=0; --idx) 
            siftDown(characters, h_size, idx);
    }

    /**
     * Find a place for a new root.
     * The new root goes down the heap until no rule break is found.
     **/
    public static void siftDown(char[] characters, int h_size, int start) {
        int idx = start;
        while (idx!=-1)  {
            idx = assertLocalHeapRules(characters, h_size, idx);
        }
    }

    /**
     * Swap the root to the sorted part.
     * When we have a proper head the root is the largest element
     * in the heap. So we can swap her to the sorted part of the
     * array and shorten the heap by one.
     **/
    public static void swapFirst(char[] characters, int h_size) {
        swapTwo(characters, 0, h_size);
    }

    /**
     * Swap to elements in the array.
     * This function swaps two char in the array.
     **/
    public static void swapTwo(char[] c, int a, int b) {
        char t = c[a];
        c[a] = c[b];
        c[b] = t;
        displayArray(c);
    }

    /**
     * Assert that the element at a given index obeys the heap rules.
     * This function assures for a given index the heap rules. If
     * elements are swaped the returned value gives the index of the
     * position where the element is swaped to. If no swap operation
     * is performed -1 is returned. For a leaf element the heap rules
     * are always true.
     * @return index of the position the element is swaped to or -1 if
     *         no swapping is performed.
     **/
    public static int assertLocalHeapRules(char[] characters, int h_size, int idx) {
        int first = idx*2+1;
        int second = idx*2+2;
        if (first>=h_size) {
            // no child in heap => we are finished
            return -1;
        } else if (second>=h_size) {
            // only one child in heap => test if we have to swap
            if (characters[idx]<characters[first]) {
                swapTwo(characters,idx,first);
                return first;
            } else return -1;
        } else {
            // two childs in heap => test if we have to swap
            if (characters[first]<characters[second]) {
                if (characters[idx]<characters[second]) {
                    swapTwo(characters,idx,second);
                    return second;
                } else if (characters[idx]<characters[first]) {
                    swapTwo(characters,idx,first);
                    return first;
                } else return -1;
            } else {
                if (characters[idx]<characters[first]) {
                    swapTwo(characters,idx,first);
                    return first;
                } else if (characters[idx]<characters[second]) {
                    swapTwo(characters,idx,second);
                    return second;
                } else return -1;
            }
        }
    }

    /**
     * Zeichnet das Array.
     **/
    public static void displayArray(char[] characters) {
        // TODO: Diese Methode muss implementiert werden.
    }


    /**
     * Die Hauptfunktion liest das Character Array und ruft die Sortierfunktion
     * und die Ausgabefunktion auf.
     **/
    public static void main (String[] args) {
        if(args.length !=1) {
            System.out.println("Bitte rufen Sie das Programm mit einem Eingabewert auf!");
            System.out.println("  java HeapSort 'dies ist ein text'");
            System.exit(-1);
        }
        char[] characters = args[0].toCharArray();
        sort(characters);
        displayArray(characters);
        System.out.println("Das Array wurde sortiert!");
    }

}

