/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import shadow.org.junit.Assert;
import shadow.org.junit.Test;

public class GenomTest
extends ConsolOutputTest {
    private int MAXIT = 100000;
    private ByteArrayOutputStream outContent;
    private ByteArrayOutputStream errContent;
    private PrintStream originalOut;
    private PrintStream originalErr;

    @Test
    public void Genom_testMethodnames() {
        try {
            Genom g = new Genom(5);
            g.toString();
            g.deletion();
            g.isEqual(g);
            g.getGenom();
            g.insertion();
            g.pointMutation();
        }
        catch (Exception e) {
            Assert.assertTrue(false);
        }
    }

    @Test
    public void Genom_testConstructor() {
        Genom g;
        boolean rand = false;
        boolean[] chars = new boolean[4];
        int counter = 0;
        for (counter = 0; !(counter >= this.MAXIT || rand && chars[0] && chars[1] && chars[2] && chars[3]); ++counter) {
            Genom gen = new Genom(4);
            Genom gen2 = new Genom(4);
            if (!Arrays.equals(gen.getGenom(), gen2.getGenom())) {
                rand = true;
            }
            block9: for (char c : gen.getGenom()) {
                switch (c) {
                    case 'A': {
                        chars[0] = true;
                        continue block9;
                    }
                    case 'C': {
                        chars[1] = true;
                        continue block9;
                    }
                    case 'G': {
                        chars[2] = true;
                        continue block9;
                    }
                    case 'T': {
                        chars[3] = true;
                        continue block9;
                    }
                    default: {
                        Assert.assertTrue(false);
                    }
                }
            }
        }
        Assert.assertTrue(rand);
        Assert.assertTrue(chars[0] && chars[1] && chars[2] && chars[3]);
        try {
            g = new Genom(0);
            Assert.assertTrue(g.getGenom().length == 0);
        }
        catch (Exception e) {
            Assert.assertTrue(false);
        }
        g = new Genom(5);
        Assert.assertTrue(g.getGenom().length == 5);
        g = new Genom(17);
        Assert.assertTrue(g.getGenom().length == 17);
        System.gc();
    }

    @Test
    public void Genom_testIsEqual() {
        int counter = 0;
        Genom gen1 = new Genom(4);
        Genom gen2 = null;
        for (counter = 0; counter < this.MAXIT && !this.equal(gen1, gen2 = new Genom(4)); ++counter) {
        }
        Assert.assertTrue(counter < this.MAXIT);
        Assert.assertTrue(gen1.isEqual(gen2));
        for (counter = 0; counter < this.MAXIT; ++counter) {
            gen2 = new Genom(4);
            if (this.equal(gen1, gen2)) continue;
            Assert.assertTrue(!gen1.isEqual(gen2));
        }
        for (counter = 0; counter < this.MAXIT; ++counter) {
            gen2 = new Genom(5);
            Assert.assertTrue(!gen1.isEqual(gen2));
        }
        for (counter = 0; counter < this.MAXIT; ++counter) {
            gen2 = new Genom(5);
            Assert.assertTrue(gen2.isEqual(gen2));
        }
        gen2 = new Genom(0);
        Assert.assertTrue(!gen1.isEqual(gen2));
        gen1 = new Genom(0);
        Assert.assertTrue(gen1.isEqual(gen2));
        System.gc();
    }

    @Test
    public void Genom_testPointmutation() {
        boolean ft = false;
        boolean lt = false;
        int counter = 0;
        Genom g = new Genom(2);
        for (counter = 0; !(counter >= this.MAXIT || ft && lt); ++counter) {
            char first = g.getGenom()[0];
            char last = g.getGenom()[1];
            g.pointMutation();
            if (first != g.getGenom()[0]) {
                ft = true;
                continue;
            }
            if (last == g.getGenom()[1]) continue;
            lt = true;
        }
        Assert.assertTrue(ft && lt);
        g = new Genom(0);
        try {
            g.pointMutation();
        }
        catch (Exception e) {
            Assert.assertTrue(false);
        }
        Assert.assertTrue(g.getGenom().length == 0);
    }

    @Test
    public void Genom_testInsertion() {
        boolean[] chars = new boolean[4];
        boolean f = false;
        boolean m = false;
        boolean e = false;
        int counter = 0;
        block8: for (counter = 0; !(counter >= this.MAXIT || chars[0] && chars[1] && chars[2] && chars[3] && f && m && e); ++counter) {
            Genom g;
            int inserted = 88;
            int tmpc = 0;
            while ((g = new Genom(2)).getGenom()[0] == g.getGenom()[1] && ++tmpc < this.MAXIT) {
            }
            Assert.assertTrue(tmpc < this.MAXIT);
            char first = g.getGenom()[0];
            char last = g.getGenom()[1];
            g.insertion();
            Assert.assertTrue(g.getGenom().length == 3);
            if (first == g.getGenom()[0] && last == g.getGenom()[1]) {
                inserted = g.getGenom()[2];
                f = true;
            } else if (first == g.getGenom()[0] && last == g.getGenom()[2]) {
                inserted = g.getGenom()[1];
                m = true;
            } else if (first == g.getGenom()[1] && last == g.getGenom()[2]) {
                inserted = g.getGenom()[0];
                e = true;
            } else {
                Assert.assertTrue(false);
            }
            switch (inserted) {
                case 65: {
                    chars[0] = true;
                    continue block8;
                }
                case 67: {
                    chars[1] = true;
                    continue block8;
                }
                case 71: {
                    chars[2] = true;
                    continue block8;
                }
                case 84: {
                    chars[3] = true;
                    continue block8;
                }
                default: {
                    Assert.assertTrue(false);
                }
            }
        }
        Assert.assertTrue(f && m && e);
        Assert.assertTrue(chars[0] && chars[1] && chars[2] && chars[3]);
        Genom g = new Genom(0);
        try {
            g.insertion();
            Assert.assertTrue(g.getGenom().length == 1);
        }
        catch (Exception ex) {
            Assert.assertTrue(false);
        }
        g = new Genom(6);
        g.insertion();
        Assert.assertTrue(g.getGenom().length == 7);
        g = new Genom(17);
        g.insertion();
        Assert.assertTrue(g.getGenom().length == 18);
        System.gc();
    }

    @Test
    public void Genom_testDeletion() {
        Genom g;
        boolean f = false;
        boolean m = false;
        boolean e = false;
        int counter = 0;
        for (counter = 0; !(counter >= this.MAXIT || f && m && e); ++counter) {
            int tmpc = 0;
            while (((g = new Genom(3)).getGenom()[0] == g.getGenom()[1] || g.getGenom()[1] == g.getGenom()[2] || g.getGenom()[0] == g.getGenom()[2]) && ++tmpc < this.MAXIT) {
            }
            Assert.assertTrue(tmpc < this.MAXIT);
            char cf = g.getGenom()[0];
            char cm = g.getGenom()[1];
            char ce = g.getGenom()[2];
            g.deletion();
            if (g.getGenom()[0] == cf && g.getGenom()[1] == cm) {
                e = true;
                continue;
            }
            if (g.getGenom()[0] == cf && g.getGenom()[1] == ce) {
                m = true;
                continue;
            }
            if (g.getGenom()[0] == cm && g.getGenom()[1] == ce) {
                f = true;
                continue;
            }
            Assert.assertTrue(false);
        }
        Assert.assertTrue(f && m && e);
        g = new Genom(2);
        g.deletion();
        Assert.assertTrue(g.getGenom().length == 1);
        try {
            g.deletion();
            Assert.assertTrue(g.getGenom().length == 0);
            g.deletion();
            Assert.assertTrue(g.getGenom().length == 0);
        }
        catch (Exception ex) {
            Assert.assertTrue(false);
        }
        g = new Genom(7);
        g.deletion();
        Assert.assertTrue(g.getGenom().length == 6);
        g = new Genom(19);
        g.deletion();
        Assert.assertTrue(g.getGenom().length == 18);
        System.gc();
    }

    private boolean equal(Genom g1, Genom g2) {
        return Arrays.equals(g1.getGenom(), g2.getGenom());
    }
}

