/*
 * Decompiled with CFR 0.152.
 */
import shadow.org.junit.Assert;
import shadow.org.junit.Test;

public class ComplexTest
extends ConsolOutputTest {
    double MAXDIF = 0.01;

    @Test
    public void testMethodNames() {
        try {
            Complex c = new Complex(1.0, 1.0);
            c.real();
            c.imag();
            c.mult(c);
            c.mult_inplace(c);
            c.add(c);
            c.add_inplace(c);
            c.sqr();
            c.sqr_inplace();
            c.abs_sqr();
        }
        catch (Exception e) {
            Assert.assertTrue(false);
        }
    }

    private boolean eq(double a, double b) {
        return Math.abs(a - b) < this.MAXDIF;
    }

    private boolean eq(Complex c, double r, double i) {
        return this.eq(c.real(), r) && this.eq(c.imag(), i);
    }

    private boolean eq(Complex c1, Complex c2) {
        return this.eq(c1.real(), c2.real()) && this.eq(c1.imag(), c2.imag());
    }

    @Test
    public void testConstructor() {
        Complex c = new Complex(1.0, 2.0);
        Assert.assertTrue(this.eq(c.real(), 1.0));
        Assert.assertTrue(this.eq(c.imag(), 2.0));
    }

    @Test
    public void testAdd() {
        Complex c1 = new Complex(2.0, -5.0);
        Complex c2 = new Complex(-2.0, 5.0);
        Complex c3 = c1.add(c2);
        Assert.assertTrue(this.eq(c1, 2.0, -5.0));
        Assert.assertTrue(this.eq(c2, -2.0, 5.0));
        Assert.assertTrue(this.eq(c3, 0.0, 0.0));
        c1 = new Complex(2.0, 0.0);
        c2 = new Complex(2.0, 5.0);
        c3 = c1.add(c2);
        Assert.assertTrue(this.eq(c1, 2.0, 0.0));
        Assert.assertTrue(this.eq(c2, 2.0, 5.0));
        Assert.assertTrue(this.eq(c3, 4.0, 5.0));
        c1 = new Complex(8.0, -2.0);
        c2 = new Complex(4.0, 8.0);
        Assert.assertTrue(this.eq(c1.add(c2), c2.add(c1)));
        Assert.assertTrue(this.eq(c1, 8.0, -2.0));
        Assert.assertTrue(this.eq(c2, 4.0, 8.0));
        c1 = new Complex(8.0, -2.0);
        Complex res = new Complex(16.0, -4.0);
        Assert.assertTrue(this.eq(c1.add(c1), res));
        c2 = c1.add(c1);
        Assert.assertTrue(!c2.equals(c1));
    }

    @Test
    public void testAdd_inplace() {
        Complex c1 = new Complex(2.0, -5.0);
        Complex c2 = new Complex(-2.0, 5.0);
        c1.add_inplace(c2);
        Assert.assertTrue(this.eq(c2, -2.0, 5.0));
        Assert.assertTrue(this.eq(c1, 0.0, 0.0));
        c1 = new Complex(2.0, 0.0);
        c2 = new Complex(2.0, 5.0);
        c1.add_inplace(c2);
        Assert.assertTrue(this.eq(c2, 2.0, 5.0));
        Assert.assertTrue(this.eq(c1, 4.0, 5.0));
        c1 = new Complex(8.0, -2.0);
        c2 = new Complex(4.0, 8.0);
        Complex c3 = new Complex(8.0, -2.0);
        Complex c4 = new Complex(4.0, 8.0);
        Assert.assertTrue(this.eq(c1.add_inplace(c2), c4.add_inplace(c3)));
        c1 = new Complex(8.0, -2.0);
        Complex res = new Complex(16.0, -4.0);
        Assert.assertTrue(this.eq(c1.add_inplace(c1), res));
        Assert.assertTrue(this.eq(c1, res));
        c2 = c1.add_inplace(c1);
        Assert.assertTrue(c2.equals(c1));
    }

    @Test
    public void testMult() {
        Complex c1 = new Complex(2.0, -5.0);
        Complex c2 = new Complex(5.0, 3.0);
        Complex res = new Complex(25.0, -19.0);
        Assert.assertTrue(this.eq(c1.mult(c2), res));
        Assert.assertTrue(this.eq(c2.mult(c1), res));
        c1 = new Complex(8.0, 7.0);
        c2 = new Complex(6.0, 12.0);
        res = new Complex(-36.0, 138.0);
        Assert.assertTrue(this.eq(c1.mult(c2), res));
        Assert.assertTrue(this.eq(c2.mult(c1), res));
        c1 = new Complex(2.0, -5.0);
        res = new Complex(-21.0, -20.0);
        Assert.assertTrue(this.eq(c1.mult(c1), res));
        c2 = c1.mult(c1);
        Assert.assertTrue(!c2.equals(c1));
    }

    @Test
    public void testMult_inplace() {
        Complex c1 = new Complex(2.0, -5.0);
        Complex c2 = new Complex(5.0, 3.0);
        Complex res = new Complex(25.0, -19.0);
        Assert.assertTrue(this.eq(c1.mult_inplace(c2), res));
        c1 = new Complex(8.0, 7.0);
        c2 = new Complex(6.0, 12.0);
        res = new Complex(-36.0, 138.0);
        Assert.assertTrue(this.eq(c1.mult_inplace(c2), res));
        c2 = new Complex(2.0, -5.0);
        c1 = new Complex(5.0, 3.0);
        res = new Complex(25.0, -19.0);
        Assert.assertTrue(this.eq(c1.mult_inplace(c2), res));
        c2 = new Complex(8.0, 7.0);
        c1 = new Complex(6.0, 12.0);
        res = new Complex(-36.0, 138.0);
        Assert.assertTrue(this.eq(c1.mult_inplace(c2), res));
        c1 = new Complex(2.0, -5.0);
        res = new Complex(-21.0, -20.0);
        Assert.assertTrue(this.eq(c1.mult_inplace(c1), res));
        Assert.assertTrue(this.eq(c1, res));
        c2 = c1.mult_inplace(c1);
        Assert.assertTrue(c2.equals(c1));
    }

    @Test
    public void testSqr() {
        Complex c1 = new Complex(2.0, -5.0);
        Complex res = new Complex(-21.0, -20.0);
        Assert.assertTrue(this.eq(c1.sqr(), res));
        c1 = new Complex(5.0, -3.0);
        res = new Complex(16.0, -30.0);
        Assert.assertTrue(this.eq(c1.sqr(), res));
        c1 = new Complex(2.0, 8.0);
        res = new Complex(-60.0, 32.0);
        Assert.assertTrue(this.eq(c1.sqr(), res));
        Complex c2 = c1.sqr();
        Assert.assertTrue(!c2.equals(c1));
    }

    @Test
    public void testSqr_inplace() {
        Complex c1 = new Complex(2.0, -5.0);
        Complex res = new Complex(-21.0, -20.0);
        Assert.assertTrue(this.eq(c1.mult_inplace(c1), res));
        Assert.assertTrue(this.eq(c1, res));
        c1 = new Complex(5.0, -3.0);
        res = new Complex(16.0, -30.0);
        Assert.assertTrue(this.eq(c1.mult_inplace(c1), res));
        Assert.assertTrue(this.eq(c1, res));
        c1 = new Complex(2.0, 8.0);
        res = new Complex(-60.0, 32.0);
        Assert.assertTrue(this.eq(c1.mult_inplace(c1), res));
        Assert.assertTrue(this.eq(c1, res));
        Complex c2 = c1.sqr_inplace();
        Assert.assertTrue(c2.equals(c1));
    }

    @Test
    public void testAbs_sqr() {
        Complex c1 = new Complex(-21.0, 20.0);
        Assert.assertTrue(this.eq(c1.abs_sqr(), 841.0));
        c1 = new Complex(8.0, 3.0);
        Assert.assertTrue(this.eq(c1.abs_sqr(), 73.0));
        c1 = new Complex(-2.0, 2.0);
        Assert.assertTrue(this.eq(c1.abs_sqr(), 8.0));
    }
}

