/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import shadow.org.junit.After;
import shadow.org.junit.Assert;
import shadow.org.junit.Before;
import shadow.org.junit.Test;

public class BMITest {
    private ByteArrayOutputStream outContent;
    private ByteArrayOutputStream errContent;
    private PrintStream originalOut;
    private PrintStream originalErr;

    @Before
    public void setUpStreams() {
        this.originalOut = System.out;
        this.originalErr = System.err;
        this.outContent = new ByteArrayOutputStream();
        this.errContent = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.outContent));
        System.setErr(new PrintStream(this.errContent));
    }

    @After
    public void cleanUpStreams() {
        System.setOut(this.originalOut);
        System.setErr(this.originalErr);
    }

    public String getOut() {
        return this.outContent.toString();
    }

    public String getErr() {
        return this.errContent.toString();
    }

    public String[] generateArray(int groesse, int gewicht) {
        String[] args = new String[]{Integer.toString(groesse), Integer.toString(gewicht)};
        return args;
    }

    @Test
    public void aufgabe2_MainMethode() {
        BMI.main((String[])this.generateArray(188, 88));
    }

    @Test
    public void aufgabe2_Parameter1() {
        BMI.main((String[])this.generateArray(188, 88));
        Assert.assertTrue(this.getOut().contains("24.8"));
    }

    @Test
    public void aufgabe2_Parameter2() {
        BMI.main((String[])this.generateArray(160, 60));
        Assert.assertTrue(this.getOut().contains("23.4"));
    }

    @Test
    public void aufgabe2_Normalgewichtig() {
        BMI.main((String[])this.generateArray(160, 60));
        Assert.assertTrue(this.getOut().contains("20") && this.getOut().contains("25"));
    }

    @Test
    public void aufgabe2_Uebergewichtig() {
        BMI.main((String[])this.generateArray(154, 60));
        Assert.assertTrue(!this.getOut().contains("20") && this.getOut().contains("25"));
    }

    @Test
    public void aufgabe2_Untergewichtig() {
        BMI.main((String[])this.generateArray(174, 60));
        Assert.assertTrue(this.getOut().contains("20") && !this.getOut().contains("25"));
    }
}

