/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import shadow.org.junit.After;
import shadow.org.junit.Assert;
import shadow.org.junit.Before;
import shadow.org.junit.Test;

public class WelcomeTest {
    private ByteArrayOutputStream outContent;
    private ByteArrayOutputStream errContent;
    private PrintStream originalOut;
    private PrintStream originalErr;

    @Before
    public void setUpStreams() {
        this.originalOut = System.out;
        this.originalErr = System.err;
        this.outContent = new ByteArrayOutputStream();
        this.errContent = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.outContent));
        System.setErr(new PrintStream(this.errContent));
    }

    @After
    public void cleanUpStreams() {
        System.setOut(this.originalOut);
        System.setErr(this.originalErr);
    }

    public String getOut() {
        return this.outContent.toString();
    }

    public String getErr() {
        return this.errContent.toString();
    }

    public String[] generateArray(String argument) {
        String[] args = new String[]{argument};
        return args;
    }

    @Test
    public void aufgabe1_MainMethode() {
        Welcome.main((String[])this.generateArray(""));
    }

    @Test
    public void aufgabe1_Parameter2() {
        Welcome.main((String[])this.generateArray("asdf"));
        Assert.assertTrue(this.getOut().contains("asdf"));
        Assert.assertTrue(this.getOut().toLowerCase().contains("hello") || this.getOut().toLowerCase().contains("hallo"));
    }

    @Test
    public void aufgabe1_Parameter1() {
        Welcome.main((String[])this.generateArray("Spock"));
        Assert.assertTrue(this.getOut().contains("Spock"));
        Assert.assertTrue(this.getOut().toLowerCase().contains("hello") || this.getOut().toLowerCase().contains("hallo"));
    }

    @Test
    public void aufgabe1_NoParameter() {
        Welcome.main((String[])this.generateArray(""));
        Assert.assertTrue(!this.getOut().toLowerCase().contains("spock"));
        Assert.assertTrue(this.getOut().toLowerCase().contains("hello") || this.getOut().toLowerCase().contains("hallo"));
    }
}

